
#ifndef _1_CRYS_ATP_TST_UTIL_Funcs_h_H
#define _1_CRYS_ATP_TST_UTIL_Funcs_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS_ATP_TST_Defines.h"
#include "DX_VOS_Timer.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Jan 13 16:27:43 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_UTIL_Funcs.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/
/******** Public Variables ********/
/******** Public Functions ********/
/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RunAllAcceptance_tests 		
 * 
 * Inputs:
 *  none
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * This function runs all of the Acceptance tests
 *
 ***************************/
 DxError_t CRYS_ATP_TST_RunAllAcceptance_tests(DxUint32_t TST_KeyGeneration_TestStatus);

/***************************
* Function Name:                                                           
* CRYS_ATP_TST_PrintHASHType
* Inputs:
*  CRYS_HASH_OperationMode_t HASHType - Hash type to Print out
*
* Outputs:
*  None                                     
*
* Description:                                                                 
* This function prints the CRYS version and sub versions
*
**************************/
void CRYS_ATP_TST_PrintHASHType(CRYS_HASH_OperationMode_t TST_HashType);

/***************************
 * Function Name:                                                           
 * CRYS_ATP_TST_ShowCRYSVersion
 * Inputs:
 *  none
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * This function prints the CRYS version and sub versions
 *
 **************************/
void CRYS_ATP_TST_ShowCRYSVersion(void);

/***************************
 * Macro Name:                                                           
 * TST_ATP_StartPerformanceTimer
 * Inputs:
 *  DxUint32_t TST_Timer - A pointer to the clock output user buffer
 *
 * Outputs:
 *  None                                     
 *
 * Description:                                                                 
 * This function starts the counter
 *
 **************************/
#if TST_ENABLE_PERFORMANCE_TST
#define TST_ATP_StartPerformanceTimer(TST_Timer) DX_VOS_StartTimer(TST_Timer)

/***************************
 * Macro Name:                                                           
 * TST_ATP_GetPerformanceTimer
 * Inputs:
 *  DxUint32_t *TST_Timer - A pointer to the clock output user buffer
 *
 * Outputs:
 *  none                                     
 *
 * Description:                                                                 
 * This function gets the counter value 
 *
 **************************/
#define TST_ATP_GetPerformanceTimer(TST_Timer) \
    DX_VOS_GetTimer(TST_Timer)

/***************************
* Macro Name:                                                           
* TST_ATP_CalcPreformance
* Inputs:
*  DxUint32_t TST_PerformanceDataSize - The Size of the Data that was processed during performance
*                                       Measurements
* Outputs:
*  none                                     
*
* Description:                                                                 
* This function uses the ticks counter value and prints out the performance measurement in
* Mbits/Sec
* 
*
**************************/
#define TST_ATP_CalcPerformance(TST_PerformanceDataSize) \
do { \
    TST_PerformanceMasure = ((float)TST_PerformanceDataSize/TST_DEVIDE_TO_CONVERT_BYTES_TO_MBIT)/((float)TST_Timer/TICKS_PER_SECOND); \
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"* Operation Performance MbitPerSec - %f \n",TST_PerformanceMasure)); \
} while (0)


#else
#define TST_ATP_StartPerformanceTimer(TST_Timer)
#define TST_ATP_GetPerformanceTimer(TST_Timer)
#define TST_ATP_CalcPerformance(TST_PerformanceDataSize)
#endif


#ifdef __cplusplus
}
#endif

#endif



